<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_backcall
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Module\Backcall\Site\Helper;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\ParameterType;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Helper for mod_backcall
 *
 * @since  1.5
 */
class BackcallHelper implements DatabaseAwareInterface
{
    use DatabaseAwareTrait;

    /**
     * Returns a list from an array
     *
     * @param   Registry         $moduleParams  The module parameters.
     * @param   SiteApplication  $app           The current application.
     *
     * @return  \stdClass[]
     *
     * @since   4.4.0
     */
    public function getModuleData(Registry $params, SiteApplication $app, $module): array
    {
        $lists = array();

        $app = Factory::getApplication();
        $lang = $app->getLanguage();

        $componentParams = ComponentHelper::getParams('com_backcall');

        if ($componentParams->get('enable_jquery', 1) == 1) {
            HTMLHelper::_('jquery.framework');
        }

        $lang->load('mod_backcall');
        $lang->load('com_backcall', 'administrator');

        $assetManager = $app->getDocument()->getWebAssetManager();

        $assetManager->registerAndUseStyle('iziModal', 'media/com_backcall/css/iziModal.css', []);
        $assetManager->registerAndUseStyle('modBackCallStyle', 'media/com_backcall/css/module.css', []);

        $uri = Uri::getInstance();
        $url = $uri->toString(array('path', 'query', 'fragment'));
        $lists['url'] = substr(URI::base(),0,-1) .$url;

        $lists['phone_input'] = 'phone'.$module->id;
        $lists['name_input'] = 'name'.$module->id;

        $lists['buttonbackcall'] = 'buttonbackcall'.$module->id;
        $lists['mainbuttonclass'] = 'mainbuttbackcall'.$module->id;
        $lists['buttsubm_dopclass'] = 'buusubmdopclass'.$module->id;
        $lists['formbackcall'] = 'formbackcall'.$module->id;
        $lists['finalmessage'] = 'finalmessage'.$module->id;

        $lists['background_tittle_color'] =  $params->get('background_tittle_color', '#f66f33');
        $lists['font_tittle_color'] = $params->get('font_tittle_color', '#fff');
        $lists['background_button_color'] = $params->get('background_button_color', '#4bae4f');
        $lists['background_button_color_hover'] = $params->get('background_button_color_hover', '#7acb5a');
        $lists['font_button_color'] = $params->get('font_button_color', '#fff');
        $lists['font_button_color_hover'] = $params->get('font_button_color_hover', '#fff');

        $lists['main_background_button_color'] = $params->get('main_background_button_color', '#4bae4f');
        $lists['main_background_button_color_hover'] = $params->get('main_background_button_color_hover', '#7acb5a');
        $lists['main_font_button_color'] = $params->get('main_font_button_color', '#fff');
        $lists['main_font_button_color_hover'] = $params->get('main_font_button_color_hover', '#fff');

        return $lists;
    }


}
