<?php
// No direct access
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;
use Joomla\CMS\Uri\Uri;

defined( '_JEXEC' ) or die;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.Honeysuckle
 * @since       2.5+
 * @author		Vladimir Egorov
 */
class HoneysuckleMain
{
    public $params;
    public $componentParams;

    public function __construct($params ='')
    {
        $params = new Registry($params);
        $this->params = $params;
        $this->componentParams = \Joomla\CMS\Component\ComponentHelper::getParams('com_honeysuckle');
    }

    public function hasCyrillic($text) {
        return preg_match('/[\p{Cyrillic}]/u', $text);
    }

    public function checkForCyrillic($requests, $object, $ip) {
        $cyrilc_params = $this->componentParams->get('cyrilc_params', '');
        $object->published = $this->componentParams->get('spam_variant', 0);

        if (!$cyrilc_params) {
            return;
        }

        $cyrilc_params = explode(',', $cyrilc_params);
        $jform = array();

        if (isset($requests['jform'])) {
            $jform = $requests['jform'];
        }

        foreach ($cyrilc_params as $check_param) {
            $check_param = trim($check_param);

            $text = '';

            if (isset($requests[$check_param])) {
                $text = $requests[$check_param];
            }

            if (!$text) {
                if (isset($jform[$check_param])) {
                    $text = $jform[$check_param];
                }
            }

            if ($text) {
                $result = $this->hasCyrillic($text);

                if (!$result) {
                    $this->addToSpam($ip, print_r($_REQUEST, true));
                    $this->setLog($object, $ip);
                    $this->SpamPage();
                }
            }
        }

    }

    public function setLog($object, $ip) {

        $uri = JUri::getInstance();
        $object->url = $uri->toString();

        $log = print_r($_REQUEST, true);
        $cut_log = $this->componentParams->get('cut_log', 1000);

        if (!is_numeric($cut_log)) {
            $cut_log = 1000;
        }

        if ($cut_log < 0) {
            $cut_log = 1000;
        }

        $log = mb_substr($log, 0, $cut_log);

        $object->log = $log;

        $object->created = date('Y-m-d H:i:s');

        $object->ip = $ip;

        Factory::getDbo()->insertObject('#__honeysuckle_logs', $object);

        $this->deleteLogs();
    }

    public function deleteLogs() {

        $duration = $this->componentParams->get('storage_time_of_logs', 60);

        $time = new DateTime();
        $time->sub(new DateInterval('PT' . $duration . 'M'));

        $newtime = $time->format('Y-m-d H:i:s');

        $db = JFactory::getDbo();

        $query = $db->getQuery(true);

        $conditions = array(
            $db->quoteName('created') . ' < ' . $db->quote($newtime)
        );

        $query->delete($db->quoteName('#__honeysuckle_logs'));
        $query->where($conditions);

        $db->setQuery($query);

        $db->execute();

    }


    public function SpamPage() {
        $customResetFromSpam = $this->componentParams->get('customResetFromSpam', 0);
        $spam_variant = $this->componentParams->get('spam_variant', 0);

        $l = 'index.php?option=com_honeysuckle&view=reset';
        $menu = $this->getMenuByLink($l);

        $uri = Uri::getInstance();
        $current_url =  $uri->toString();


        if (!$customResetFromSpam || !$menu || $spam_variant == -7) {
            die('you spam bot!');
        }

        $app = Factory::getApplication();
        $input = $app->input;

        $link = Route::_($l.'&Itemid='.$menu->id);

        $option = $input->get('option' ,'', 'RAW');
        $view = $input->get('view' ,'');

        $redirect = 1;
        $find_alias = 1;
        $alias = $menu->alias;

        $pos = strpos($current_url, $alias);

        if ($pos === false) {
            $find_alias = 0;
        }

        if (($option == 'com_honeysuckle' && $view == 'reset') || $find_alias ) {
            $redirect = 0;
        }

        if ($redirect) {
            $app->redirect($link);
        }

    }

    public function getMenuByLink($link) {

        $database = Factory::getDBO();
        $query = "SELECT * FROM #__menu WHERE link = '".$link."' AND menutype <> 'main'";
        $database->setQuery( $query);

        $result = $database->loadObject();

        if ($result) {
            $result->params = new \Joomla\Registry\Registry($result->params);
        }

        return $result;

    }

    public function checkRequestText($string) {

        $frazes = $this->getStopWords();


       foreach ($frazes as $fraze) {
           $findme   = $fraze;
           $pos = strpos($string, $findme);

           if ($pos != false) {
               return true;
           }
       }

       return false;
    }

    public function getStopWords() {
        $db = Factory::getDbo();
        $query = $db
            ->getQuery(true)
            ->select('word')
            ->from($db->quoteName('#__honeysuckle_stop_words'));

        $db->setQuery($query);
        $result = $db->loadColumn();

        return $result;
    }

    public function addToWhite($ip, $reason = '') {
        $spam_user = new stdClass();
        $spam_user->ip = $ip;
        $spam_user->reason = $reason;
        $spam_user->published = 1;
        $spam_user->created = date('Y-m-d H:i:s');

        $ipinfo = $this->getIpInfo($ip);

        if ($ipinfo->status == 'success') {
            $spam_user->country = $ipinfo->country;
            $spam_user->countryCode = $ipinfo->countryCode;
            $spam_user->regionName = $ipinfo->regionName;
            $spam_user->city = $ipinfo->city;
        }

        Factory::getDbo()->insertObject('#__honeysuckle_spam', $spam_user);

    }

    public function setLogSpamStatus($ip, $status) {
        $object = new stdClass();
        $object->ip = $ip;
        $object->published = $status;

        Factory::getDbo()->updateObject('#__honeysuckle_logs', $object,'ip', true);
    }
    public function addToSpam($ip, $reason = '') {
        $spam_user = new stdClass();
        $spam_user->ip = $ip;

        if ($reason) {

            $cut_log = $this->componentParams->get('cut_log', 1000);

            if (!is_numeric($cut_log)) {
                $cut_log = 1000;
            }

            if ($cut_log < 0) {
                $cut_log = 1000;
            }

            $reason = mb_substr($reason, 0, $cut_log);

        }

        $spam_user->reason = $reason;
        $spam_user->published = $this->componentParams->get('spam_variant', 0);
        $spam_user->created = date('Y-m-d H:i:s');

        $ipinfo = $this->getIpInfo($ip);

        if ($ipinfo->status == 'success') {
            $spam_user->country = $ipinfo->country;
            $spam_user->countryCode = $ipinfo->countryCode;
            $spam_user->regionName = $ipinfo->regionName;
            $spam_user->city = $ipinfo->city;
        }

        Factory::getDbo()->insertObject('#__honeysuckle_spam', $spam_user);

        if ($this->componentParams->get('generatekey_after_add_to_spam', 0) == 1) {
            $cronkey = $this->params->get('key', '');
            file_get_contents(Uri::root().'index.php?action=setsessionfield&key='.$cronkey);
        }

    }

    public function getIpInfo($ip) {

        $ch = curl_init('http://ip-api.com/json/' .$ip . '?lang=ru');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HEADER, false);
        $res = curl_exec($ch);
        curl_close($ch);

        $result = (object)json_decode($res, true);

        return $result;
    }


    public function checkIpFromSpamList($ip, $published = -1) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->quoteName('#__honeysuckle_spam'));
        $query->where($db->quoteName('ip')." = ".$db->quote($ip));

        if ($published > -1) {
            $query->where($db->quoteName('published')." = 0");
        }


        $db->setQuery($query);
        $result = $db->loadObject();

        return $result;
    }

    public function getUserIpAddr(){
        if(!empty($_SERVER['HTTP_CLIENT_IP'])){
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }else{
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }


}