<?php
/**
 * @version    CVS: 2.0.0
 * @package    com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2021 Vladimir Egorov
 * @license    Commercial license
 */

// No direct access
defined('_JEXEC') or die;


use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/src/Helper/');
HTMLHelper::_('bootstrap.tooltip');
HTMLHelper::_('behavior.multiselect');


$user = Factory::getUser();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');
$canOrder = $user->authorise('core.edit.state', 'com_honeysuckle');
$saveOrder = $listOrder = 'a.ordering';


echo \Joomla\Component\Honeysuckle\Administrator\Helper\HoneysuckleHelper::showDonat();
?>

<form action="<?php echo Route::_('index.php?option=com_honeysuckle&view=logs'); ?>" method="post"
      name="adminForm" id="adminForm">
    <div class="row">
        <div class="col-md-12">
            <div id="j-main-container" class="j-main-container">
                <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

                <div class="clearfix"></div>
                <table class="table table-striped" id="timeList">
                    <thead>
                    <tr>
                        <th width="1%" class="hidden-phone">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_( 'JGLOBAL_CHECK_ALL' ); ?>" onclick="Joomla.checkAll(this)" />
                        </th>
                        <th width="5%" style="min-width:55px" class="center">
                            <?php echo HTMLHelper::_( 'searchtools.sort', 'JSTATUS', 'published', $listDirn, $listOrder ); ?>
                        </th>
                        <th width="10%">
                            <?php echo HTMLHelper::_( 'searchtools.sort', 'COM_HONEYSUCKLE_IP', 'ip', $listDirn, $listOrder ); ?>
                        </th>
                        <th width="30%">
                            <?php echo Text::_('COM_HONEYSUCKLE_REQUEST' ); ?>
                        </th>
                        <th width="30%">
                            <?php echo Text::_( 'COM_HONEYSUCKLE_URL' ); ?>
                        </th>
                        <th width="10%" class="hidden-phone">
                            <?php echo HTMLHelper::_( 'searchtools.sort', 'JDATE', 'created', $listDirn, $listOrder ); ?>
                        </th>

                    </tr>
                    </thead>
                    <tfoot>
                    <tr>
                        <td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                    </tfoot>
                    <tbody <?php if ($saveOrder) : ?> class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" <?php endif; ?>>
                    <?php foreach ($this->items as $i => $item) :
                        $ordering = ($listOrder == 'a.ordering');
                        $canCreate = $user->authorise('core.create', 'com_honeysuckle');
                        $canEdit = $user->authorise('core.edit', 'com_honeysuckle');
                        $canCheckin = $user->authorise('core.manage', 'com_honeysuckle');
                        $canChange = $user->authorise('core.edit.state', 'com_honeysuckle');
                        ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td>
                                <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                            </td>
                            <td>
                                <?php echo HTMLHelper::_('jgrid.published', $item->state, $i, 'logs.', $canChange, 'cb'); ?>
                            </td>
                            <td>
                                    <strong>
                                        <?php echo $item->ip; ?>
                                    </strong>
                                <?php if ($item->spam == 0) { ?>
                                    <div class="spammess">
                                        <?php echo Text::_('COM_HONEYSUCKLE_SPAM') ?>
                                    </div>
                                <?php } ?>
                                <?php if ($item->spam == -7) { ?>
                                    <div class="alwaysblocked spammess">
                                        <?php echo Text::_('COM_HONEYSUCKLE_ALWAYS_F') ?>
                                    </div>
                                <?php } ?>
                            </td>
                            <td class="maxw">
                                <div class="log_text">
                                      <?php echo  strip_tags(htmlspecialchars($item->log)) ?>
                                </div>

                            </td>
                            <td class="maxw">
                                <div class="url_text">
                                    <?php
                                    $u = str_replace('&', '&<br>', $item->url);
                                    ?>
                                    <a  target="_blank" href="<?php echo  $item->url ?>">
                                        <?php echo $u ?>
                                    </a>
                                </div>
                            </td>
                            <td class="wrap small hidden-phone">
                                <?php echo  date ('<b>H:i</b> d.m.Y', strtotime($item->created)); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>

                <input type="hidden" id="task" name="task" value=""/>
                <input type="hidden" name="boxchecked" value="0"/>
                <input type="hidden" name="list[fullorder]" value="<?php echo $listOrder; ?> <?php echo $listDirn; ?>"/>
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>
</form>

