<?php

// No direct access
defined( '_JEXEC' ) or die;

/**
 * Object Class Table
 * @author Vladimir Egorov
 */
class TableHoneysuckle_Stop_words extends JTable
{

    /**
     * Class constructor
     * @param Object $db (database link object)
     */
    function __construct( &$db )
    {
        parent::__construct( '#__honeysuckle_stop_words', 'id', $db );
    }

    /**
     * Method for loading data into the object field
     * @param Array $array (Featured in the field of data)
     * @param String $ignore
     * @return Boolean result
     */
    public function bind( $array, $ignore = '' )
    {

        if ( empty( $array['created'] ) ) {
            $array['created'] = date( 'Y-m-d H:i:s' );
        }
        if ( isset( $array['rules'] ) && is_array( $array['rules'] ) ) {
            $rules = new JAccessRules( $array['rules'] );
            $this->setRules( $rules );
        }

        return parent::bind( $array, $ignore );
    }

}