<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Migation_instruments
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2023 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Migrationinstruments\Component\Migation_instruments\Administrator\View\Mains;
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use \Migrationinstruments\Component\Migation_instruments\Administrator\Helper\Migation_instrumentsHelper;
use \Joomla\CMS\Toolbar\Toolbar;
use \Joomla\CMS\Toolbar\ToolbarHelper;
use \Joomla\CMS\Language\Text;
use \Joomla\Component\Content\Administrator\Extension\ContentComponent;
use \Joomla\CMS\Form\Form;
use \Joomla\CMS\HTML\Helpers\Sidebar;

class HtmlView extends BaseHtmlView
{
	protected $items;

	protected $pagination;

	protected $state;


	public function display($tpl = null)
	{


		$this->addToolbar();

		$this->sidebar = Sidebar::render();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	protected function addToolbar()
	{

		$canDo = Migation_instrumentsHelper::getActions();

		ToolbarHelper::title(Text::_('COM_MIGATION_INSTRUMENTS_TITLE_MAINS'), "generic");

		$toolbar = Toolbar::getInstance('toolbar');



		if ($canDo->get('core.admin'))
		{
			$toolbar->preferences('com_migation_instruments');
		}

		// Set sidebar action
		Sidebar::setAction('index.php?option=com_migation_instruments&view=mains');
	}

}
