<?php

// No direct access
defined( '_JEXEC' ) or die;
require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
/**
 * Object Class Table
 * @author Vladimir Egorov
 */
class TableHoneysuckle_Spam extends JTable
{

	/**
	 * Class constructor
	 * @param Object $db (database link object)
	 */
	function __construct( &$db )
	{
		parent::__construct( '#__honeysuckle_spam', 'id', $db );
	}

	/**
	 * Method for loading data into the object field
	 * @param Array $array (Featured in the field of data)
	 * @param String $ignore
	 * @return Boolean result
	 */
	public function bind( $array, $ignore = '' )
	{
        $HoneysuckleMain = new HoneysuckleMain();

        if (isset($array['ip'])) {
            if ($array['ip']) {
                $HoneysuckleMain->setLogSpamStatus($array['ip'], $array['published']);
            }
        }

        if ( empty( $array['created'] ) ) {
            $array['created'] = date( 'Y-m-d H:i:s' );
        }

        if ( (empty( $array['country'] ) || $array['country'] == '') && (isset($array['ip']) && $array['ip'] != '') ) {
            $ipinfo = $HoneysuckleMain->getIpInfo($array['ip']);

            if ($ipinfo->status == 'success') {
                $array['country'] = $ipinfo->country;
                $array['countryCode'] = $ipinfo->countryCode;
                $array['regionName'] = $ipinfo->regionName;
                $array['city'] = $ipinfo->city;
            }
        }

		if ( isset( $array['rules'] ) && is_array( $array['rules'] ) ) {
			$rules = new JAccessRules( $array['rules'] );
			$this->setRules( $rules );
		}

		return parent::bind( $array, $ignore );
	}

}