<?php

defined( '_JEXEC' ) or die;

/**
 * Class HoneysuckleHelper
 */
class HoneysuckleHelper
{
	/**
	 * Добавление подменю
	 * @param String $vName
	 */
	static function addSubmenu( $vName )
	{
        JSubMenuHelper::addEntry(
            JText::_( 'COM_HONEYSUCKLE_LOGS' ),
            'index.php?option=com_honeysuckle&view=logs',
            $vName == 'logs' );
        JSubMenuHelper::addEntry(
			JText::_( 'COM_HONEYSUCKLE_IPS' ),
			'index.php?option=com_honeysuckle&view=spams',
			$vName == 'spams' );

        JSubMenuHelper::addEntry(
            JText::_( 'COM_HONEYSUCKLE_STOP_WORDS' ),
            'index.php?option=com_honeysuckle&view=stop_words',
            $vName == 'stop_words' );
	}

	/**
	 * Получаем доступные действия для текущего пользователя
	 * @return JObject
	 */
	public static function getActions()
	{
		$user = JFactory::getUser();
		$result = new JObject;
		$assetName = 'com_honeysuckle';
		$actions = JAccess::getActions( $assetName );
		foreach ( $actions as $action ) {
			$result->set( $action->name, $user->authorise( $action->name, $assetName ) );
		}
		return $result;
	}
}