<?php

// No direct access


defined( '_JEXEC' ) or die;

/**
 * View to display a list of items
 * @author Vladimir Egorov
 */
class HoneysuckleViewLogs extends JViewLegacy
{
	/**
	 * @var $items stdClass[]
	 */
	public $items;
	/**
	 * @var $pagination JPagination
	 */
	public $pagination;
	/**
	 * @var $state JObject
	 */
	public $state;
	/**
	 * @var $user JUser
	 */
	public $user;
	/**
	 * @var $authors stdClass[]
	 */
	public $authors;

	/**
	 * Method to display the current pattern
	 * @param type $tpl
	 */
	public function display( $tpl = null )
	{
        $doc = JFactory::getDocument();
        $doc->addStyleSheet(JUri::root().'administrator/components/com_honeysuckle/assets/css/honeysuckle.css?v=2');

        $this->user = JFactory::getUser();
		$this->items = $this->get( 'Items' );

        if (is_array($this->items)) {
            if (count($this->items)) {
                foreach ($this->items as $key=>$item) {
                    if ($item->spam === null) {
                        $item->spam = 1;
                    }
                    $this->items[$key]->state = $item->spam;
                }
            }
        }

		$this->pagination = $this->get( 'Pagination' );
		$this->state = $this->get( 'State' );
		$this->authors = $this->get( 'Authors' );
		$this->user = JFactory::getUser();
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->loadHelper( 'honeysuckle' );
		if ( $this->getLayout() !== 'modal' ) {
			$this->addToolbar();
			honeysuckleHelper::addSubmenu( 'logs' );
		}

        $options	= array();
        $options[]	= JHtml::_('select.option', '2', JText::_('COM_HONEYSUCKLE_FILTER_SPAM_SELECT_VAR0'));
        $options[]	= JHtml::_('select.option', '7', JText::_('COM_HONEYSUCKLE_ALWAYS_F'));
        $options[]	= JHtml::_('select.option', '3', JText::_('Jall'));

        $this->spamfilter = $options;


		parent::display( $tpl );
	}

	/**
	 * Method to display the toolbar
	 */
	protected function addToolbar()
	{
		JToolBarHelper::title( JText::_( 'COM_HONEYSUCKLE_LOGS' ) );
		$canDo = honeysuckleHelper::getActions( 'spam' );


		if ( $canDo->get( 'core.edit.state' ) ) {
			JToolBarHelper::divider();


			if ( $canDo->get( 'core.delete' ) ) {
				JToolBarHelper::deleteList( 'DELETE_QUERY_STRING', 'logs.delete', 'JTOOLBAR_DELETE' );
				JToolBarHelper::divider();
                JToolBarHelper::custom('logs.deleteall', 'delete.png', 'extrahello_f2.png', 'COM_HONEYSUCKLE_DELETE_ALL', false);
			}

			if ( $canDo->get( 'core.admin' ) ) {
				JToolBarHelper::preferences( 'com_honeysuckle' );
				JToolBarHelper::divider();
			}
		}		
	}

	protected function getSortFields()
	{
		return array(
			'ordering' => JText::_( 'JGRID_HEADING_ORDERING' ),
			'published' => JText::_( 'JSTATUS' ),
			'title' => JText::_( 'JGLOBAL_TITLE' ),
			'created_by' => JText::_( 'JAUTHOR' ),
			'created' => JText::_( 'JDATE' ),
			'id' => JText::_( 'JGRID_HEADING_ID' )
		);
	}
}