<?php
/** @var $this HoneysuckleViewSpams */


defined( '_JEXEC' ) or die;// No direct access

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');

$user = JFactory::getUser();
$userId = $user->get( 'id' );

$listOrder = $this->escape( $this->state->get( 'list.ordering' ) );
$listDirn = $this->escape( $this->state->get( 'list.direction' ) );
$saveOrder = $listOrder == 'ordering';

if ( $saveOrder ) {
	$saveOrderingUrl = 'index.php?option=com_honeysuckle&task=spams.saveOrderAjax&tmpl=component';
	JHtml::_( 'sortablelist.sortable', 'articleList', 'adminForm', strtolower( $listDirn ), $saveOrderingUrl );
}
$sortFields = $this->getSortFields();
$xml = JFactory::getXML(JPATH_SITE .DIRECTORY_SEPARATOR.'administrator'.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_honeysuckle'.DIRECTORY_SEPARATOR.'honeysuckle.xml');
$version = (string)$xml->version;
?>
<script type="text/javascript">
	Joomla.orderTable = function () {
		var table = document.getElementById("sortTable");
		var direction = document.getElementById("directionTable");
		var order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>') {
			dirn = 'asc';
		} else {
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>

<form action="<?php echo JRoute::_( 'index.php?option=com_honeysuckle&view=spams' ); ?>" method="post" name="adminForm" id="adminForm" class="sitogonAdminForm">
	<?php if (!empty( $this->sidebar )): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
		<?php else : ?>
		<div id="j-main-container">
			<?php endif; ?>
            <fieldset id="filter-bar">
                <div class="filter-search fltlft">
                    <input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_CONTENT_FILTER_SEARCH_DESC'); ?>" />
                    <button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
                    <button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
                </div>
                <div class="filter-select fltrt">
                    <select id="filter_published" name="filter_published" class="form-select" onchange="this.form.submit();" aria-describedby="filter_published-desc">
                        <option value="" selected="selected"><?php echo JText::_('COM_HONEYSUCKLE_FILTER_SPAM_SELECT') ?></option>
                        <?php echo JHtml::_('select.options', $this->spamfilter, 'value', 'text', $this->state->get('filter.published'));?>
                    </select>
                </div>
            </fieldset>
            <div class="clr"> </div>
			<table class="table table-striped" id="articleList">
				<thead>
                <tr>
                    <th width="1%" class="hidden-phone">
                        <input type="checkbox" name="checkall-toggle" value=""
                               title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>"
                               onclick="Joomla.checkAll(this)"/>
                    </th>
                    <th width="5%" style="min-width:55px" class="center">
                        <?php echo JHtml::_('grid.sort', 'JSTATUS', 'state', $listDirn, $listOrder); ?>
                    </th>
                    <th width="10%">
                        <?php echo JHtml::_( 'grid.sort', 'COM_HONEYSUCKLE_IP', 'ip', $listDirn, $listOrder ); ?>
                    </th>
                    <th>
                        <?php echo JHtml::_('grid.sort', 'COM_HONEYSUCKLE_REASON', 'reason', $listDirn, $listOrder); ?>
                    </th>
                    <th>
                        <?php echo JHtml::_('grid.sort', 'COM_HONEYSUCKLE_COUNTRY', 'country', $listDirn, $listOrder); ?>
                    </th>
                    <th>
                        <?php echo JHtml::_('grid.sort', 'COM_HONEYSUCKLE_REGION', 'regionName', $listDirn, $listOrder); ?>
                    </th>
                    <th>
                        <?php echo JHtml::_('grid.sort', 'COM_HONEYSUCKLE_CITY', 'city', $listDirn, $listOrder); ?>
                    </th>
                    <th width="10%" class="hidden-phone">
                        <?php echo JHtml::_('grid.sort', 'JDATE', 'created', $listDirn, $listOrder); ?>
                    </th>

                </tr>
				</thead>
				<tbody>
				<?php foreach ( $this->items as $i => $item ) :
					$item->max_ordering = 0;
					$ordering = ( $listOrder == 'a.ordering' );
					$canEdit = $user->authorise( 'core.edit', '#__spam.' . $item->id );
					$canCheckin = $user->authorise( 'core.manage', 'com_honeysuckle' ) || $item->checked_out == $userId || $item->checked_out == 0;
					$canEditOwn = $user->authorise( 'core.edit.own', '#__spam.' . $item->id );
					$canChange = $user->authorise( 'core.edit.state', '#__spam.' . $item->id ) && $canCheckin;
					?>
					<tr class="row<?php echo $i % 2; ?>">
						<td class="center hidden-phone">
							<?php echo JHtml::_( 'grid.id', $i, $item->id ); ?>
						</td>
						<td class="center">
							<div class="btn-group">
								<?php echo JHtml::_( 'jgrid.published', $item->state, $i, 'spams.', $canChange, 'cb' ); ?>
							</div>
						</td>
						<td class="ttl">
							<div class="pull-left">

                                <a href="<?php echo JRoute::_( 'index.php?option=com_honeysuckle&task=spam.edit&id=' . $item->id ); ?>" title="<?php echo JText::_( 'JACTION_EDIT' ); ?>"><?php echo $item->ip; ?></a>

                                <?php if ($item->state == 0) { ?>
                                    <div class="spammess">
                                        <?php echo JText::_('COM_HONEYSUCKLE_SPAM') ?>
                                    </div>
                                <?php } ?>
                                <?php if ($item->state == -7) { ?>
                                    <div class="alwaysblocked spammess">
                                        <?php echo JText::_('COM_HONEYSUCKLE_ALWAYS_F') ?>
                                    </div>
                                <?php } ?>
							</div>

						</td>
                        <td class="small hidden-phone">
                            <?php echo $item->reason; ?>
                        </td>
                        <td class="contryblock">
                            <?php if ($item->countryCode) { ?>
                                <img src="<?php echo JUri::root() ?>administrator/components/com_honeysuckle/assets/images/<?php echo strtolower($item->countryCode) ?>.jpg" />
                                <div class="contrytxt">
                                    <?php echo $item->country; ?>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="small hidden-phone nowrap">
                            <?php echo $item->regionName; ?>
                        </td>
                        <td class="small hidden-phone nowrap">
                            <?php echo $item->city; ?>
                        </td>
                        <td class="nowrap small hidden-phone">
                            <?php echo  date ('<b>H:i</b> d.m.Y', strtotime($item->created)); ?>
                        </td>

					</tr>
				<?php endforeach; ?>
				</tbody>
			</table>
			<?php echo $this->pagination->getListFooter(); ?>
            <div class="razrabotka">
                <div><?php echo JText::sprintf('COM_HONEYSUCKLE_VERSION', $version) ?></div>
                <div><?php echo JText::_('COM_HONEYSUCKLE_DEVELOPER_SITE') ?></div>
            </div>

			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo JHtml::_( 'form.token' ); ?>

		</div>
</form>