<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Migation_instruments
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2023 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Migrationinstruments\Component\Migation_instruments\Administrator\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;

/**
 * Mains list controller class.
 *
 * @since  1.0.0
 */
class MainsController extends AdminController
{

	public function getModel($name = 'Main', $prefix = 'Administrator', $config = array())
	{
		return parent::getModel($name, $prefix, array('ignore_request' => true));
	}

    public function myextpagetitle() {
        $app = Factory::getApplication();
        $db = Factory::getContainer()->get('DatabaseDriver');
        $SitogonHelper = new \SitogonHelper();
        $link = '/administrator/index.php?option=com_migation_instruments&view=mains';

        $articlies = $SitogonHelper->getJoomlaArticlies();

        $c = 0;

        foreach ($articlies as $article) {

            $metadata = $article->metadata;

            if (!$SitogonHelper->isJson($metadata)) {
                continue;
            }

            $metadata = (array)json_decode($metadata);

            if (!isset($metadata['browser_title'])) {
                continue;
            }

            $attribs = (array)json_decode($article->attribs);

            if (!isset($attribs['article_page_title'])) {
                $attribs['article_page_title'] = '';
            }

            if ($metadata['browser_title'] && !$attribs['article_page_title']) {
                $attribs['article_page_title'] = $metadata['browser_title'];
                $attribs = json_encode($attribs);
                $article->attribs = $attribs;
                $db->updateObject('#__content', $article, 'id', true);
                $c++;
            }
        }

        $app->enqueueMessage(Text::sprintf('COM_MIGATION_INSTRUMENTS_OPERATION_SUCCESS',  $c));
        $app->redirect($link);


    }
}
