<?php
/**
 * @package     Shortcode Ultimate
 * @subpackage  Editors-xtd insert shortcode
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

defined('_JEXEC') or die;

/**
 * Editor SHortcode Ultimate button
 *
 * @package     Shortcode Ultimate
 * @subpackage  Editors-xtd insert shortcode
 * @since       1.0
 */
class PlgButtonShortcode_Ultimate extends JPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * Display the button.
	 *
	 * @param   string   $name    The name of the button to display.
	 * @param   string   $asset   The name of the asset being edited.
	 * @param   integer  $author  The id of the author owning the asset being edited.
	 *
	 * @return  array    A two element array of (shortcode, textToInsert) or false if not authorised.
	 */
	public function onDisplay($name)
	{
		$app = Factory::getApplication();
		$user = Factory::getUser();
		$extension = $app->input->get('option');

		$plugin = PluginHelper::getPlugin('system', 'bdthemes_shortcodes');
		$params = new Registry($plugin->params);

        if (
            $user->authorise('core.create', 'com_bdthemes_shortcodes')
            || $user->authorise('core.edit', 'com_bdthemes_shortcodes')
            || $user->authorise('core.edit.own', 'com_bdthemes_shortcodes')
        ) {


			if ($params->get('shortcode_intro', 1) ) {
				// For showing intro in shortcode ultimate button.
				$doc = Factory::getDocument();
				$doc->addScript(BDT_SU_URI . '/js/intro-su-button.js');
			}


            $link = 'index.php?option=com_bdthemes_shortcodes&amp;layout=modal&amp;view=config&amp;tmpl=component&e_name='.$name;
			$button = new CMSObject();
			$button->class = 'btn btn-default';
			$button->link = $link;
            $button->icon    = 'list';
			$button->text = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INSERT_SHORTCODE');
			$button->title = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INSERT_SHORTCODE_DESC');
			$button->name =  $this->_type . '_' . $this->_name;
			$button->modal = true;
			$button->options = "{handler: 'iframe', size: {x: 960, y: 640}}";

			return $button;
		}
	}
}
