<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\Model;
// No direct access.
defined('_JEXEC') or die;

use \Joomla\CMS\MVC\Model\ListModel;
use \Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Helper\TagsHelper;
use \Joomla\Database\ParameterType;
use \Joomla\Utilities\ArrayHelper;
use Honeysuckle\Component\Honeysuckle\Administrator\Helper\HoneysuckleHelper;

/**
 * Methods supporting a list of Logs records.
 *
 * @since  1.0.0
 */
class SpamsModel extends ListModel
{
    /**
     * Constructor.
     *
     * @param   array  $config  An optional associative array of configuration settings.
     *
     * @see        JController
     * @since      1.6
     */
    public function __construct($config = array())
    {
        if (empty($config['filter_fields']))
        {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'state', 'a.state',
                'ordering', 'a.ordering',
                'created_by', 'a.created_by',
                'country', 'a.country',
                'regionName', 'a.regionName',
                'city', 'a.city',
                'ip', 'a.ip',
                'modified_by', 'a.modified_by',
            );
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = null, $direction = null)
    {
        // List state information.
        parent::populateState("a.created", "DESC");

        $context = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
        $this->setState('filter.search', $context);

        // Split context into component and optional section
        $parts = FieldsHelper::extract($context);

        if ($parts)
        {
            $this->setState('filter.component', $parts[0]);
            $this->setState('filter.section', $parts[1]);
        }
    }


    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.state');


        return parent::getStoreId($id);

    }

    public function getSpams($published = 0) {

        $db = $this->getDbo();
        $query = $db->getQuery( true );
        $query->select( 'a.ip' );

        $query->from( '#__honeysuckle_spam as a' );


        if (  (int)$published != 0 && (int)$published != 3 ) {
            if ((int)$published == 2) {
                $query->where('a.published=0');
            }
            if ((int)$published == 1) {
                $query->where('a.published=1');
            }
        }

        $query->order( $this->getDbo()->escape( 'id DESC' ) );
        $db->setQuery($query);

        $result = $db->loadColumn();

        return $result;
    }

    public function deleteips($ips) {
        if (!is_array($ips)) {
            return false;
        }

        if (!count($ips)) {
            return false;
        }

        $db = Factory::getDbo();

        foreach ($ips as $key=>$ip) {
            $ips[$key] = $db->quote(trim($ip));
        }

        $ips = implode(',', $ips);

        $query = $db->getQuery(true);

        $query->where('ip IN ('.$ips.')');

        $query->delete($db->quoteName('#__honeysuckle_spam'));


        $db->setQuery($query);

        $db->execute();
    }

    public function deleteall() {
        $db = Factory::getDbo();

        $query = $db->getQuery(true);


        $query->delete($db->quoteName('#__honeysuckle_spam'));


        $db->setQuery($query);

        $db->execute();
    }


    protected function getListQuery()
    {
        $query = $this->getDbo()->getQuery( true );
        $query->select( 'a.*, a.published as state' );

        $query->from( '#__honeysuckle_spam as a' );
        $published = $this->getState( 'filter.published' );

        if (  (int)$published != 0 && (int)$published != 3 ) {
            if ((int)$published == 2) {
                $query->where('a.published=0');
            }
            if ((int)$published == 1) {
                $query->where('a.published=1');
            }

            if ((int)$published == 7) {
                $query->where('a.published=-7');
            }
        }

        $search = $this->getState( 'filter.search' );
        if ( !empty( $search ) ) {
            $search = $this->getDbo()->Quote( '%' . $this->getDbo()->escape( $search, true ) . '%' );
            $query->where( '(a.ip LIKE ' . $search . ' OR a.country LIKE '.$search.')' );
        }
        $orderCol = $this->state->get( 'list.ordering' );
        $orderDirn = $this->state->get( 'list.direction' );

        $query->order( $this->getDbo()->escape( $orderCol . ' ' . $orderDirn ) );
        return $query;
    }

    /**
     * Get an array of data items
     *
     * @return mixed Array of data items on success, false on failure.
     */
    public function getItems()
    {
        $items = parent::getItems();
        return $items;
    }
}
