<?php
// No direct access
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;
use Joomla\CMS\Uri\Uri;

defined( '_JEXEC' ) or die;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.Honeysuckle
 * @since       2.5+
 * @author		Vladimir Egorov
 */
class HoneysuckleMain
{
    public $params;
    public $componentParams;

    public function __construct($params ='')
    {
        $params = new Registry($params);
        $this->params = $params;
        $this->componentParams = \Joomla\CMS\Component\ComponentHelper::getParams('com_honeysuckle');
    }

    public function SpamPage() {
        $customResetFromSpam = $this->componentParams->get('customResetFromSpam', 0);
        $l = 'index.php?option=com_honeysuckle&view=reset';
        $menu = $this->getMenuByLink($l);

        $uri = Uri::getInstance();
        $current_url =  $uri->toString();


        if (!$customResetFromSpam || !$menu) {
            die('you spam bot!');
        }

        $app = Factory::getApplication();
        $input = $app->input;

        $link = Route::_($l.'&Itemid='.$menu->id);

        $option = $input->get('option' ,'', 'RAW');
        $view = $input->get('view' ,'');

        $redirect = 1;
        $find_alias = 1;
        $alias = $menu->alias;

        $pos = strpos($current_url, $alias);

        if ($pos === false) {
            $find_alias = 0;
        }

        if (($option == 'com_honeysuckle' && $view == 'reset') || $find_alias ) {
            $redirect = 0;
        }

        if ($redirect) {
            $app->redirect($link);
        }

    }

    public function getMenuByLink($link) {

        $database = Factory::getDBO();
        $query = "SELECT * FROM #__menu WHERE link = '".$link."' AND menutype <> 'main'";
        $database->setQuery( $query);

        $result = $database->loadObject();

        if ($result) {
            $result->params = new \Joomla\Registry\Registry($result->params);
        }

        return $result;

    }

    public function checkRequestText($string) {

        $frazes = $this->getStopWords();


       foreach ($frazes as $fraze) {
           $findme   = $fraze;
           $pos = strpos($string, $findme);

           if ($pos != false) {
               return true;
           }
       }

       return false;
    }

    public function getStopWords() {
        $db = Factory::getDbo();
        $query = $db
            ->getQuery(true)
            ->select('word')
            ->from($db->quoteName('#__honeysuckle_stop_words'));

        $db->setQuery($query);
        $result = $db->loadColumn();

        return $result;
    }

    public function addToWhite($ip, $reason = '') {
        $spam_user = new stdClass();
        $spam_user->ip = $ip;
        $spam_user->reason = $reason;
        $spam_user->published = 1;
        $spam_user->created = date('Y-m-d H:i:s');

        $ipinfo = $this->getIpInfo($ip);

        if ($ipinfo->status == 'success') {
            $spam_user->country = $ipinfo->country;
            $spam_user->countryCode = $ipinfo->countryCode;
            $spam_user->regionName = $ipinfo->regionName;
            $spam_user->city = $ipinfo->city;
        }

        Factory::getDbo()->insertObject('#__honeysuckle_spam', $spam_user);

    }

    public function setLogSpamStatus($ip, $status) {
        $object = new stdClass();
        $object->ip = $ip;
        $object->published = $status;

        Factory::getDbo()->updateObject('#__honeysuckle_logs', $object,'ip', true);
    }
    public function addToSpam($ip, $reason = '') {
        $spam_user = new stdClass();
        $spam_user->ip = $ip;

        if ($reason) {

            $cut_log = $this->componentParams->get('cut_log', 1000);

            if (!is_numeric($cut_log)) {
                $cut_log = 1000;
            }

            if ($cut_log < 0) {
                $cut_log = 1000;
            }

            $reason = mb_substr($reason, 0, $cut_log);

        }

        $spam_user->reason = $reason;
        $spam_user->published = 0;
        $spam_user->created = date('Y-m-d H:i:s');

        $ipinfo = $this->getIpInfo($ip);

        if ($ipinfo->status == 'success') {
            $spam_user->country = $ipinfo->country;
            $spam_user->countryCode = $ipinfo->countryCode;
            $spam_user->regionName = $ipinfo->regionName;
            $spam_user->city = $ipinfo->city;
        }

        Factory::getDbo()->insertObject('#__honeysuckle_spam', $spam_user);

    }

    public function getIpInfo($ip) {

        $ch = curl_init('http://ip-api.com/json/' .$ip . '?lang=ru');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HEADER, false);
        $res = curl_exec($ch);
        curl_close($ch);

        $result = (object)json_decode($res, true);

        return $result;
    }


    public function checkIpFromSpamList($ip, $published = -1) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->quoteName('#__honeysuckle_spam'));
        $query->where($db->quoteName('ip')." = ".$db->quote($ip));

        if ($published > -1) {
            $query->where($db->quoteName('published')." = 0");
        }


        $db->setQuery($query);
        $result = $db->loadObject();

        return $result;
    }

    public function getUserIpAddr(){
        if(!empty($_SERVER['HTTP_CLIENT_IP'])){
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }else{
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }


}