<?php

// No direct access
defined( '_JEXEC' ) or die;

/**
 * @author Vladimir Egorov
 */
class HoneysuckleModelLogs extends JModelList
{

    /**
     * Конструктор класса
     * @param Array $config
     */
    public function __construct( $config = array() )
    {
        if ( empty( $config['filter_fields'] ) ) {
            $config['filter_fields'] = array(
                'id',
                'published',
                'ip',
                'ordering',
                'created_by',
                'modified_by',
            );
        }
        parent::__construct( $config );
    }

    public function deleteall() {
        $db = JFactory::getDbo();

        $query = $db->getQuery(true);


        $query->delete($db->quoteName('#__honeysuckle_logs'));


        $db->setQuery($query);

        $result = $db->execute();
    }

    /**
     * @param String $ordering
     * @param String $direction
     */
    protected function populateState( $ordering = null, $direction = null )
    {
        if ( $layout = JFactory::getApplication()->input->get( 'layout' ) ) {
            $this->context .= '.' . $layout;
        }
        $search = $this->getUserStateFromRequest( $this->context . '.filter.search', 'filter_search' );
        $this->setState( 'filter.search', $search );
        $published = $this->getUserStateFromRequest( $this->context . '.filter.published', 'filter_published', '' );
        $this->setState( 'filter.published', $published );
        parent::populateState( 'created', 'desc' );
    }

    /**
     * @param string $id
     * @return string
     */
    protected function getStoreId( $id = '' )
    {
        $id .= ':' . $this->getState( 'filter.search' );
        $id .= ':' . $this->getState( 'filter.published' );
        $id .= ':' . $this->getState( 'filter.author_id' );
        return parent::getStoreId( $id );
    }

    /**
     * Составление запроса для получения списка записей
     * @return JDatabaseQuery
     */
    protected function getListQuery()
    {
        $query = $this->getDbo()->getQuery( true );
        $query->select( 't1.*' );
        $query->select( 'spam.published as spam' );

        $query->from( '#__honeysuckle_logs as t1' );

        $query->join('LEFT', $this->getDbo()->quoteName('#__honeysuckle_spam', 'spam') . ' ON ' . $this->getDbo()->quoteName('t1.ip') . ' = ' . $this->getDbo()->quoteName('spam.ip'));

        $published = $this->getState( 'filter.published' );

        if (  (int)$published != 0 && (int)$published != 3 ) {
            if ((int)$published == 2) {
                $query->where('spam.published=0');
            }
            if ((int)$published == 1) {
                $query->where('spam.published=1');
            }

            if ((int)$published == 7) {
                $query->where('spam.published=-7');
            }
        }


        $search = $this->getState( 'filter.search' );
        $search = trim($search);
        if ( !empty( $search ) ) {
            $search = $this->getDbo()->Quote( '%' . $this->getDbo()->escape( $search, true ) . '%' );
            $query->where( '(t1.log LIKE ' . $search . ' OR t1.ip LIKE ' . $search . ')' );
        }
        $orderCol = $this->state->get( 'list.ordering' );
        $orderDirn = $this->state->get( 'list.direction' );
        $query->order( $this->getDbo()->escape( $orderCol . ' ' . $orderDirn ) );
        return $query;
    }


}