<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;
use HoneysuckleMain;
use stdClass;

require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
class LogsController extends AdminController
{
    public function publish()
    {
        $cids = $this->app->input->get('cid', '', 'array');
        $task = $this->app->input->get('task', '');
        $model = $this->getModel('Oboronalog');

        $link = Route::_('index.php?option=com_honeysuckle&view=logs');

        if (count($cids)) {
            foreach ($cids as $cid) {

                $one_log = $model->getItem($cid);
                if ($task == 'unpublish') {
                    $value = 0;
                } else {
                    $value = 1;
                }
                $this->changeSpamList($one_log, $model, $value);
            }
        }

        $this->app->enqueueMessage(Text::sprintf('COM_HONEYSUCKLE_N_ITEMS_ADDED_SPAM'.$value, count($cids)));
        $this->app->redirect($link);


    }

    public function changeSpamList($one_log, $model, $value)
    {
        $HoneysuckleMain = new HoneysuckleMain();
        
        $object = new stdClass();
        $object->ip = $one_log->ip;

        $current_ip = $model->getIpFromSpamList($one_log->ip);

        if (!$value) {
            $object->reason = $one_log->log;
        } else {
            $object->reason = '';
        }

        $ipinfo = $HoneysuckleMain->getIpInfo($object->ip);

        if ($ipinfo->status == 'success') {
            $object->country = $ipinfo->country;
            $object->countryCode = $ipinfo->countryCode;
            $object->regionName = $ipinfo->regionName;
            $object->city = $ipinfo->city;
        }

        $object->published = $value;

        if ($current_ip) {
            $object->created = $current_ip->created;
            $object->id = $current_ip->id;

            Factory::getDbo()->updateObject('#__honeysuckle_spam', $object, 'id');
        } else {
            $object->created = date('Y-m-d H:i:s');
            Factory::getDbo()->insertObject('#__honeysuckle_spam', $object);
        }

        $for_all_object = new stdClass();
        $for_all_object->ip = $object->ip;
        $for_all_object->published = $value;

        Factory::getDbo()->updateObject('#__honeysuckle_logs', $for_all_object, 'ip');

    }



    public function deleteall() {
        $app = Factory::getApplication();

        $model = $this->getModel('Logs');

        $model->deleteall();

        $link = 'index.php?option=com_honeysuckle&view=logs';

        $this->app->enqueueMessage(Text::_('COM_HONEYSUCKLE_SUCCESS_OPERATION'));

        $app->redirect($link);
    }


	public function getModel($name = 'Oboronalog', $prefix = 'Administrator', $config = array())
	{
		return parent::getModel($name, $prefix, array('ignore_request' => true));
	}

	

	/**
	 * Method to save the submitted ordering values for records via AJAX.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 *
	 * @throws  Exception
	 */
	public function saveOrderAjax()
	{
		// Get the input
		$pks   = $this->input->post->get('cid', array(), 'array');
		$order = $this->input->post->get('order', array(), 'array');

		// Sanitize the input
		ArrayHelper::toInteger($pks);
		ArrayHelper::toInteger($order);

		// Get the model
		$model = $this->getModel();

		// Save the ordering
		$return = $model->saveorder($pks, $order);

		if ($return)
		{
			echo "1";
		}

		// Close the application
		Factory::getApplication()->close();
	}
}
