<?php
/**
 * @version    CVS: 2.0.0
 * @package    com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2021 Vladimir Egorov
 * @license    Commercial license
 */

// No direct access
defined('_JEXEC') or die;


use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/src/Helper/');
HTMLHelper::_('bootstrap.tooltip');
HTMLHelper::_('behavior.multiselect');


$user = Factory::getUser();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');
$canOrder = $user->authorise('core.edit.state', 'com_honeysuckle');
$saveOrder = $listOrder = 'a.ordering';

if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_honeysuckle&task=logs.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
    HTMLHelper::_('draggablelist.draggable');
}

?>

<form action="<?php echo Route::_('index.php?option=com_honeysuckle&view=stop_words'); ?>" method="post"
      name="adminForm" id="adminForm">
    <div class="row">
        <div class="col-md-12">
            <div id="j-main-container" class="j-main-container">
                <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

                <div class="clearfix"></div>
                <table class="table table-striped" id="timeList">
                    <thead>
                    <tr>
                        <th width="1%" class="hidden-phone">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_( 'JGLOBAL_CHECK_ALL' ); ?>" onclick="Joomla.checkAll(this)" />
                        </th>
                        <th width="5%" style="min-width:55px" class="center">
                            <?php echo HTMLHelper::_( 'searchtools.sort', 'JSTATUS', 'state', $listDirn, $listOrder ); ?>
                        </th>
                        <th>
                            <?php echo HTMLHelper::_( 'searchtools.sort', 'COM_HONEYSUCKLE_STOP_WORD', 'ip', $listDirn, $listOrder ); ?>
                        </th>
                        <th width="10%" class="hidden-phone">
                            <?php echo HTMLHelper::_( 'searchtools.sort', 'JDATE', 'created', $listDirn, $listOrder ); ?>
                        </th>
                    </tr>
                    </thead>
                    <tfoot>
                    <tr>
                        <td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                    </tfoot>
                    <tbody <?php if ($saveOrder) : ?> class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" <?php endif; ?>>
                    <?php foreach ($this->items as $i => $item) :
                        $ordering = ($listOrder == 'a.ordering');
                        $canCreate = $user->authorise('core.create', 'com_honeysuckle');
                        $canEdit = $user->authorise('core.edit', 'com_honeysuckle');
                        $canCheckin = $user->authorise('core.manage', 'com_honeysuckle');
                        $canChange = $user->authorise('core.edit.state', 'com_honeysuckle');
                        ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td>
                                <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                            </td>
                            <td>
                                <?php echo HTMLHelper::_('jgrid.published', $item->state, $i, 'stop_words.', $canChange, 'cb'); ?>
                            </td>
                            <td class="nowrap has-context">
                                <div class="pull-left">

                                    <a href="<?php echo Route::_( 'index.php?option=com_honeysuckle&task=stop_word.edit&id=' . $item->id ); ?>" title="<?php echo Text::_( 'JACTION_EDIT' ); ?>"><?php echo $item->word; ?></a>


                                </div>
                                <div class="pull-left">
                                    <?php
                                    // Create dropdown items
                                    HTMLHelper::_( 'dropdown.edit', $item->id, 'Spam.' );
                                    HTMLHelper::_( 'dropdown.divider' );
                                    if ( $item->state ) :
                                        HTMLHelper::_( 'dropdown.unpublish', 'cb' . $i, 'stop_words.' );
                                    else :
                                        HTMLHelper::_( 'dropdown.publish', 'cb' . $i, 'stop_words.' );
                                    endif;

                                    // render dropdown list
                                    echo HTMLHelper::_( 'dropdown.render' );
                                    ?>
                                </div>

                            </td>

                            <td class="nowrap small hidden-phone">
                                <?php echo $item->created; ?>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>

                <input type="hidden" id="task" name="task" value=""/>
                <input type="hidden" name="boxchecked" value="0"/>
                <input type="hidden" name="list[fullorder]" value="<?php echo $listOrder; ?> <?php echo $listDirn; ?>"/>
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>
</form>

