<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Joomla\Component\Honeysuckle\Administrator\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;
use stdClass;

/**
 * Logs list controller class.
 *
 * @since  1.0.0
 */
class Stop_wordsController extends AdminController
{
    public function publish()
    {
        $cids = $this->app->input->get('cid', '', 'array');
        $task = $this->app->input->get('task', '');
        $model = $this->getModel('Stop_word');

        $link = Uri::base().'index.php?option=com_honeysuckle&view=stop_words';

        if (count($cids)) {
            foreach ($cids as $cid) {

                $one_ip = $model->getItem($cid);
                if ($task == 'unpublish') {
                    $value = 0;
                } else {
                    $value = 1;
                }
                $for_all_object = new stdClass();
                $for_all_object->published = $value;
                $for_all_object->id = $one_ip->id;


                Factory::getDbo()->updateObject('#__honeysuckle_stop_words', $for_all_object, 'id');
            }
        }

        $this->app->enqueueMessage(Text::sprintf('COM_HONEYSUCKLE_N_ITEMS_PUBLISHED'.$value, count($cids)));
        $this->app->redirect($link);


    }


    public function getModel($name = 'Stop_word', $prefix = 'Administrator', $config = array())
    {
        return parent::getModel($name, $prefix, array('ignore_request' => true));
    }



    /**
     * Method to save the submitted ordering values for records via AJAX.
     *
     * @return  void
     *
     * @since   1.0.0
     *
     * @throws  Exception
     */
    public function saveOrderAjax()
    {
        // Get the input
        $pks   = $this->input->post->get('cid', array(), 'array');
        $order = $this->input->post->get('order', array(), 'array');

        // Sanitize the input
        ArrayHelper::toInteger($pks);
        ArrayHelper::toInteger($order);

        // Get the model
        $model = $this->getModel();

        // Save the ordering
        $return = $model->saveorder($pks, $order);

        if ($return)
        {
            echo "1";
        }

        // Close the application
        Factory::getApplication()->close();
    }
}
