<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  system.honeysuckle
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Plugin\System\Honeysuckle\Extension;

use DateInterval;
use DateTime;
use HoneysuckleMain;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\Router;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\SubscriberInterface;



\defined('_JEXEC') or die;

require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
/**
 * Жимолость
 *
 * 1.1
 */
final class Honeysuckle extends CMSPlugin implements SubscriberInterface
{

    use DatabaseAwareTrait;

    public $mainclass;
    public $componentParams;
    public $checkFromSpamList;
    public $isSpam;
    public $Check;
    protected $autoloadLanguage = true;


    public static function getSubscribedEvents(): array
    {
        /**
         * Note that onAfterInitialise must be the first handlers to run for this
         * plugin to operate as expected. These handlers load compatibility code which
         * might be needed by other plugins
         */
        return [
            'onAfterInitialise' => 'onAfterInitialise',
            'onAfterRender'     => 'onAfterRender',
        ];
    }

    public function __construct(DispatcherInterface $dispatcher, array $config = [])
    {

        $uri = Uri::getInstance();
        $current_url = $uri->toString();

        $check = mb_strpos($current_url, 'joomlaupdate/healthcheck');
        if ($check) {
            return;
        }

        $this->mainclass = new HoneysuckleMain($config['params']);
        parent::__construct($dispatcher, $config);
        $this->loadLanguage();
    }

    public function onAfterInitialise(){
        $uri = Uri::getInstance();
        $current_url = $uri->toString();

        $check = mb_strpos($current_url, 'joomlaupdate/healthcheck');
        if ($check) {
            return;
        }

        $app = Factory::getApplication();
        $input = $app->getInput();

        $action = $input->get('action', '');
        $key = $input->get('key', '');

        if ($action == 'setsessionfield' && $key) {
            $this->setSessionNameField($key) ;
        }

        $this->componentParams = ComponentHelper::getParams('com_honeysuckle');

        if ($app->isClient('administrator')) {
            return;
        }

        if ( $this->componentParams->get('access_only_for_ip', '') != '') {
            $this->checkAccess( $this->componentParams->get('access_only_for_ip', ''));
        }

        $ip = $this->mainclass->getUserIpAddr();

        $this->checkFromSpamList = $this->mainclass->checkIpFromSpamList($ip);

        if ($this->checkFromSpamList) {
            if ($this->checkFromSpamList->published == -7) {
                die('you spam bot!');
            }
        }

        $this->isSpam = 0;
        $this->Check = 1;

        if ($this->checkFromSpamList) {
            if ($this->checkFromSpamList->published <=0) {
                $this->isSpam = 1;
            }

            if ($this->checkFromSpamList->published == 1) {
                $object = new stdClass();
                $object->published =1;
                $this->setLog($object, $ip);
                return;
            }
        }

        if ($this->isSpam == 1 ) {
            $this->mainclass->SpamPage();
        }

        $this->addSpamopronaLog($ip);

    }

    private function setSessionNameField($key) {
        if ($key != $this->params->get('key', '')) {
            die();
        }

        $extension_id = PluginHelper::getPlugin('system','honeysuckle')->id;

        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db
            ->getQuery(true)
            ->select('*')
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('extension_id') . " = " . $extension_id);

        $db->setQuery($query);
        $plugin = $db->loadObject();
        $params = (object)json_decode($plugin->params);
        $newkey = $this->generateRandomString(12);
        $params->session_name_field = $newkey;

        $plugin->params = json_encode($params);

        $db->updateObject('#__extensions', $plugin, 'extension_id');
    }

    private function generateRandomString($length = 10) {
        $characters = 'abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function checkAccess($ips) {

        $ips_arr = explode(',', $ips);
        $current_ip = $this->mainclass->getUserIpAddr();
        $yes = 0;

        foreach ($ips_arr as $item) {
            if (trim($item) == $current_ip) {
                $yes = 1;
            }
        }

        if (!$yes) {
            die('Access Denied');
        }
    }


    public function addSpamopronaLog($ip) {
        $app = Factory::getApplication();
        $user = $app->getIdentity();

        $object = new \stdClass();
        $requests = $_REQUEST;
        $object->ip = $ip;

        if (count($requests) > 0  ) {

            if (!$user->guest) {
                $this->Check = 0;
            }

            $chck_for_url = false;

            if ( $this->componentParams->get('check_for_stop_words', 0) == 1) {

                $chck_for_url = $this->mainclass->checkRequestText(print_r($_REQUEST, true));

            }

            if ($chck_for_url && $this->Check) {
                $object->published = 0;
                $this->mainclass->addToSpam($ip, print_r($_REQUEST, true));
                $this->setLog($object, $ip);
                $this->mainclass->SpamPage();
            } else {
                $object->published = 1;
            }


            $check = true;

            if (!$user->guest ) {
                $check = false;
            }

            $input = $app->input;
            $option = $input->get('option', '');
            $source = $input->get('source', '');

            $denied_components = $this->componentParams->get('denied_components', array());

            if (count($denied_components)) {
                if (in_array($option, $denied_components)) {
                    $check = false;
                }
            }

            $field_actions = $this->params->get('session_name_field', '', 'RAW');

            if ($option == 'com_j_sms_registration' && $this->Check && !$source) {
                $this->checkJSmsRegistration($requests, $field_actions, $ip);
            }

            $non_check_params = $this->componentParams->get('non_check_params', '');

            if (trim($non_check_params) != '') {
                $non_check_params = explode(',', $non_check_params);

                foreach ($non_check_params as $check_param) {
                    if (isset($requests[$check_param])) {
                        $check = false;
                    }
                }
            }


            $required_for_verification_components = $this->componentParams->get('required_for_verification_components', array());

            if (in_array($option, $required_for_verification_components) && $this->Check) {
                $this->checkJSmsRegistration($requests, $field_actions, $ip);
            }

            if ($option == '' && isset($requests[$field_actions])) {
                if ($requests[$field_actions] == 0) {
                    $object->published = 0;
                    $this->mainclass->addToSpam($ip, print_r($_REQUEST, true));
                    $this->setLog($object, $ip);
                    $this->mainclass->SpamPage();
                }
            }


            if ($check && $this->Check) {


                $check_field = $input->get($field_actions, 0);

                if ((!$check_field && isset($requests[$field_actions])) ) {
                    $object->published = 0;
                    $this->mainclass->addToSpam($ip, print_r($_REQUEST, true));
                    $this->setLog($object, $ip);
                    $this->mainclass->SpamPage();
                }
            }


            $object->published =1;
            $this->setLog($object, $ip);

        }

    }

    public function checkJSmsRegistration($requests, $field_actions, $ip) {

        if (!isset($requests[$field_actions])) {
            $object = new \stdClass();
            $object->published = 0;
            $this->mainclass->addToSpam($ip, print_r($_REQUEST, true));
            $this->setLog($object, $ip);
            $this->mainclass->SpamPage();
        }
    }

    public function checkForComponents($field_actions) {

        $app = Factory::getApplication();
        $input = $app->input;

        $tasks = array();
        $tasks[] = 'contact.submit';
        $tasks[] = 'user.login';
        $tasks[] = 'saveUser';

        $task = $input->get('task', '', 'RAW');
        $check = $input->get($field_actions, 0);

        if (in_array($task, $tasks) && !$check) {
            return true;
        }

        return false;

    }

    public function setLog($object, $ip) {

        $uri = Uri::getInstance();
        $object->url = $uri->toString();

        $log = print_r($_REQUEST, true);
        $cut_log = $this->componentParams->get('cut_log', 1000);

        if (!is_numeric($cut_log)) {
            $cut_log = 1000;
        }

        if ($cut_log < 0) {
            $cut_log = 1000;
        }

        $log = mb_substr($log, 0, $cut_log);

        $object->log = $log;

        $object->created = date('Y-m-d H:i:s');

        $object->ip = $ip;

        Factory::getDbo()->insertObject('#__honeysuckle_logs', $object);

        $this->deleteLogs();
    }

    public function deleteLogs() {

        $duration = $this->componentParams->get('storage_time_of_logs', 60);

        $time = new DateTime();
        $time->sub(new DateInterval('PT' . $duration . 'M'));

        $newtime = $time->format('Y-m-d H:i:s');

        $db = Factory::getContainer()->get('DatabaseDriver');

        $query = $db->getQuery(true);

        $conditions = array(
            $db->quoteName('created') . ' < ' . $db->quote($newtime)
        );

        $query->delete($db->quoteName('#__honeysuckle_logs'));
        $query->where($conditions);

        $db->setQuery($query);

        $db->execute();

    }

    public function isPluginPage() {
        $app = Factory::getApplication();
        $input = $app->getInput();

        $option = $input->get('option', '');
        $view = $input->get('view', '');
        $layout = $input->get('layout', '');
        $extension_id = $input->get('extension_id', '');

        if ($option == 'com_plugins' && $view == 'plugin' && $layout == 'edit' && $extension_id == PluginHelper::getPlugin('system','honeysuckle')->id) {
            return true;
        }

        return false;
    }

    private function adminPlugin() {
        $app = Factory::getApplication();

        $html = '';

        if ($this->isPluginPage() && $this->params->get('key', '')) {
            $html .= '<script>';
            $html .= 'var PLG_HONEYSUCKLE_CRON_URL = "'.Text::_('PLG_SYSTEM_HONEYSUCKLE_CRON_URL').'";';
            $html .= 'var cron_key ="'.Uri::root().'index.php?action=setsessionfield&key='.$this->params->get('key', '').'";';
            $html .= '</script>';
            $html .= '<script src="'.Uri::root().'plugins/system/honeysuckle/libs/jquery.js"></script>';
            $html .= '<script src="'.Uri::root().'plugins/system/honeysuckle/libs/admin.js"></script>';
        }

        $sHtml = $app->getBody();

        $sHtml = str_replace('</body>', $html.'</body>', $sHtml);

        $app->setBody($sHtml);

    }


    private function find($element, $html) {
        $html = strtolower($html);

        $pos = strpos($html, $element);

        if ($pos === false) {
            return false;
        } else {
            return  true;
        }
    }



    function onAfterRender(){


        $app = Factory::getApplication();
        $user = $app->getIdentity();

        if ($app->isClient('administrator')) {
            $this->adminPlugin();
            return;
        }


        $field_name = $this->params->get('session_name_field', 'fldsessname');

        $input_html = '<input type="hidden" value="0" class="sitogon_click_counter" name = "'.$field_name.'" />';

        $sHtml = $app->getBody();

        preg_match_all('/<form[^>]*?>(.*?)<\/form>/si', $sHtml, $forms);

        if ($user->guest) {

            foreach ($forms[0] as $form) {

                $set = 0;

                $selects = $this->find('<select', $form);

                if ($selects) {
                    $set = 1;
                }

                $texareas= $this->find('<textarea', $form);

                if ($texareas) {
                    $set = 1;
                }

                $fields = array();
                $fields[] = 'type="text"';
                $fields[] = 'type="tel"';
                $fields[] = 'type="password"';
                $fields[] = 'type="email"';
                $fields[] = 'type="phone"';
                $fields[] = 'type="number"';
                $fields[] = 'type="url"';
                $fields[] = 'type="search"';


                foreach ($fields as $field) {
                    $s = $this->find($field, $form);
                    if ($s) {
                        $set = 1;
                    }
                }

                $denieds = array();
                $denieds[] = 'name="quantity[]"';

                foreach ($denieds as $denied) {
                    $d = $this->find($denied, $form);
                    if ($d) {
                        $set = 0;
                    }
                }

                if ($set) {

                    $old_form = $form;
                    $new_form = str_replace('</form>', $input_html.'</form>', $form);

                    $sHtml = str_replace($old_form, $new_form, $sHtml);
                }


            }
        }



        $form = '<form id="sitogonbottomform">';
        $form .= $input_html;
        $form .= '</form>';

        $dop_script = '<script src="'.Uri::root().'plugins/system/honeysuckle/libs/script.js"></script>';

        $sHtml = str_replace('</body>',$form.$dop_script.'</body>', $sHtml );

        $app->setBody($sHtml);


    }


}
