<?php

// No direct access
use Joomla\CMS\Factory;

defined( '_JEXEC' ) or die;

/**
 * View to display a list of items
 * @author Vladimir Egorov
 */
class HoneysuckleViewLogs extends JViewLegacy
{
	/**
	 * @var $items stdClass[]
	 */
	public $items;
	/**
	 * @var $pagination JPagination
	 */
	public $pagination;
	/**
	 * @var $state JObject
	 */
	public $state;
	/**
	 * @var $user JUser
	 */
	public $user;
	/**
	 * @var $authors stdClass[]
	 */
	public $authors;

	/**
	 * Method to display the current pattern
	 * @param type $tpl
	 */
	public function display( $tpl = null )
	{
        $this->user = \Joomla\CMS\Factory::getUser();
		$this->items = $this->get( 'Items' );

        if (is_array($this->items)) {
            if (count($this->items)) {
                foreach ($this->items as $key=>$item) {
                    if ($item->spam === null) {
                        $item->spam = 1;
                    }
                    $this->items[$key]->state = $item->spam;
                }
            }
        }

		$this->pagination = $this->get( 'Pagination' );
		$this->state = $this->get( 'State' );
		$this->authors = $this->get( 'Authors' );
		$this->user = JFactory::getUser();
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->loadHelper( 'honeysuckle' );
        HoneysuckleHelper::loadAssets();
		if ( $this->getLayout() !== 'modal' ) {
			$this->addToolbar();
			honeysuckleHelper::addSubmenu( 'logs' );
			$this->sidebar = JHtmlSidebar::render();
		}
		parent::display( $tpl );
	}

	/**
	 * Method to display the toolbar
	 */
	protected function addToolbar()
	{
		JToolBarHelper::title( JText::_( 'COM_HONEYSUCKLE_LOGS' ) );
		$canDo = honeysuckleHelper::getActions( 'spam' );


		if ( $canDo->get( 'core.edit.state' ) ) {
			JToolBarHelper::divider();


			if ( $canDo->get( 'core.delete' ) ) {
				JToolBarHelper::deleteList( 'DELETE_QUERY_STRING', 'logs.delete', 'JTOOLBAR_DELETE' );
				JToolBarHelper::divider();
                JToolBarHelper::custom('logs.deleteall', 'delete.png', 'extrahello_f2.png', 'COM_HONEYSUCKLE_DELETE_ALL', false);
			}

			if ( $canDo->get( 'core.admin' ) ) {
				JToolBarHelper::preferences( 'com_honeysuckle' );
				JToolBarHelper::divider();
			}
		}		
	}

	protected function getSortFields()
	{
		return array(
			'ordering' => JText::_( 'JGRID_HEADING_ORDERING' ),
			'published' => JText::_( 'JSTATUS' ),
			'title' => JText::_( 'JGLOBAL_TITLE' ),
			'created_by' => JText::_( 'JAUTHOR' ),
			'created' => JText::_( 'JDATE' ),
			'id' => JText::_( 'JGRID_HEADING_ID' )
		);
	}
}