<?php

defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Jsmsregistration\Component\J_sms_registration\Site\Helper\J_sms_registrationHelper;
use Jsmsregistration\Component\J_sms_registration\Site\Helper\JsmsHelper;


class telegramHelper
{

    public function sendToTelegramm($content, $recipients) {

        if (trim($content) == '') {
            return;
        }

        $content = str_replace("_", "\\_", $content);
        $content = str_replace('<br>',  chr(10), $content);
        $content = str_replace('</br>',  chr(10), $content);

        foreach ($recipients as $recipient) {
            $result =  $this->callApi( 'sendMessage', array(
                'chat_id'               => $recipient['chat_id'],
                'text'                  => $content,
                'parse_mode' => 'Markdown'
            ),
                $recipient['token']);


        }
    }

    public function sendFile($recipient, $caption, $file, $filename, $mime) {
        $token = $recipient->telegram_token;


        $arrayQuery = array(
            'chat_id' => $recipient->telegram_chatid,
            'caption' => $caption,
            'parse_mode' => 'Markdown',
            'document' => curl_file_create($file, $mime , $filename)
        );
        $ch = curl_init('https://api.telegram.org/bot'. $token .'/sendDocument');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arrayQuery);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        $res = curl_exec($ch);
        curl_close($ch);
    }

    public function isTelegram($item) {
        if (!isset($item->telegram_token) || !isset($item->telegram_chatid)) {
            return false;
        }

        if ($item->telegram_token == '' || $item->telegram_chatid == '') {
            return false;
        }

        return true;
    }

    private function callApi( $method, $params, $token ) {
        $url = sprintf(
            "https://api.telegram.org/bot%s/%s",
            $token,
            $method
        );

        $ch = curl_init();
        curl_setopt_array( $ch, array(
            CURLOPT_URL             => $url,
            CURLOPT_POST                => TRUE,
            CURLOPT_RETURNTRANSFER  => TRUE,
            CURLOPT_FOLLOWLOCATION  => FALSE,
            CURLOPT_HEADER          => FALSE,
            CURLOPT_TIMEOUT         => 10,
            CURLOPT_HTTPHEADER      => array( 'Accept-Language: ru,en-us'),
            CURLOPT_POSTFIELDS      => $params,

        ));

        $response = curl_exec($ch);
        return json_decode( $response);
    }

}