<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_backcall
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Module\Backcall\Site\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Dispatcher class for mod_backcall
 *
 * @since  4.4.0
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Returns the layout data.
     *
     * @return  array
     *
     * @since   4.4.0
     */
    protected function getLayoutData(): array
    {
        $data = parent::getLayoutData();

        $variables = $this->getHelperFactory()->getHelper('BackcallHelper')->getModuleData($data['params'], $data['app'], $data['module']);

        foreach ($variables as $key=>$variable) {
            $data[$key] = $variable;
        }

        return $data;
    }
}
