<?php
defined ('_JEXEC') or  die('Direct Access to ' . basename (__FILE__) . ' is not allowed.');
/*
 * Module Helper
 * @package VirtueMart
 * @copyright (C) 2011 - 2021 The VirtueMart Team
 * @Email: max@virtuemart.net
 *
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 *
 * @link https://virtuemart.net
 */

class mod_virtuemart_category {

    public static function vm_template_get_tree_recurse($category,$childs,$parentCategories,$vendorId,$class_sfx,$ID,$level = 0){
        $VirtueMartModelCategory = new VirtueMartModelCategory();
        $content 	= '';

        if(is_array($childs) && sizeof($childs)):
            ++$level;
            ob_start(); ?>

            <ul class="menu<?php echo $class_sfx; ?> list-sub level<?php echo $level; ?>">
                <?php
                foreach ($childs as $child) {

                    $active_menu = 'VmClose';
                    if (in_array( $child->virtuemart_category_id, $parentCategories)) $active_menu = 'active';


                    $caturl = JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id='.$child->virtuemart_category_id);
                    $cattext = $child->category_name;
                    $child->childs = $VirtueMartModelCategory->getChildCategoryList($vendorId, $child->virtuemart_category_id );

                    ?>

                    <li id="vm-category-<?php echo $child->virtuemart_category_id; ?>" class="category-<?php echo $child->virtuemart_category_id; ?><?php if (is_array($child->childs) && sizeof($child->childs)):?> parent has-children<?php endif; ?> <?php echo $active_menu ?>">
                        <?php echo JHTML::link($caturl, $cattext); ?>
                        <?php
                        if (is_array($child->childs) && sizeof($child->childs)) {
                            ?>
                            <span class="VmArrow"><i class="fa fa-caret-down"></i></span>
                            <?php
                        }
                        ?>
                        <?php if (is_array($child->childs) && sizeof($child->childs)) { ?>
                            <?php echo self::vm_template_get_tree_recurse($child,$child->childs,$parentCategories,$vendorId,$class_sfx,$ID,$level); ?>
                        <?php } ?>
                    </li>
                <?php 	} ?>
            </ul>
            <?php
            $content 	= ob_get_contents();
            ob_end_clean();
        endif;

        return $content;
    }

	static function displayCatsMod($module, $params, $active_category_id, $category_id, $layout){

		vmLanguage::loadJLang('mod_virtuemart_category', true);

		/* Setting */
		$categoryModel = VmModel::getModel('Category');
		$ID = str_replace('.', '_', substr(microtime(true), -8, 8));   //legacy
		$class_sfx = $params->get('class_sfx', '');
		$moduleclass_sfx = $params->get('moduleclass_sfx','');
		//$layout = $params->get('layout','default');
		//$active_category_id = vRequest::getInt('virtuemart_category_id', '0');
		$vendorId = 1;

		$level = (int)$params->get('level','2');


		if( strpos($layout, 'wall')!==FALSE ){
			$media = true;
		} else {
			$media = (int)$params->get('media', 0);
		}

		$categories = array();
		vmSetStartTime('categories');
		//VirtueMartModelCategory::rekurseCategories($vendorId, $category_id, $categories, $level, 0, 0,true, '', 'c.ordering, category_name', 'ASC', true, 0, $media);
		$categories = VirtueMartModelCategory::getCatsTree(true, $vendorId, $category_id, $level, $media);
		vmTime('my categories module time','categories');

		$parentCategories = $categoryModel->getCategoryRecurse($active_category_id,0);

		ob_start();
		/* Load tmpl default */
		require(JModuleHelper::getLayoutPath('mod_virtuemart_category',$layout));
		$output = ob_get_clean();
		echo $output;
	}
}

?>