<?php
/**
 * @copyright	Copyright (c) 2023 correctedimages. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// no direct access
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

/**
 * system - correctedimages Plugin
 *
 * @package		Joomla.Plugin
 * @subpakage	correctedimages.correctedimages
 */
class plgsystemcorrectedimages extends JPlugin {

	/**
	 * Constructor.
	 *
	 * @param 	$subject
	 * @param	array $config
	 */
	function __construct(&$subject, $config = array()) {
		// call parent constructor
		parent::__construct($subject, $config);
	}

    public function onContentAfterSave($context, $article, $isNew)
    {
        $object = new stdClass();
        $object->id = $article->id;
        $images = $article->images;
        $images = (object)json_decode($images);
        $images->image_intro = $this->setImage($images->image_intro);
        $images->image_fulltext = $this->setImage($images->image_fulltext);

        $object->images = json_encode($images);

        $db = Factory::getContainer()->get('DatabaseDriver');

        $updateNulls = true;

        $db->updateObject('#__content', $object, 'id', $updateNulls);

        return true;
    }

    public function setImage($image) {
        if (!$image) {
            return '';
        }

        $pos = strpos($image, '#');

        if ($pos === false) {
            return $image;
        } else {
            $i = explode('#', $image);
            return $i[0];
        }
    }
}