<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  editors-xtd.insertsitogonvkvideo
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Plugin\EditorsXtd\Insertsitogonvkvideo\Extension;

use Joomla\CMS\Editor\Button\Button;
use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\Router;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;


\defined('_JEXEC') or die;


/**
 * Кнопка для редактора - вставка VK Video
 *
 * 1.0
 */
final class Insertsitogonvkvideo extends CMSPlugin implements SubscriberInterface
{
    use SiteRouterAwareTrait;
    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;



    public static function getSubscribedEvents(): array
    {
        return ['onEditorButtonsSetup' => 'onEditorButtonsSetup'];
    }

    /**
     * @param  EditorButtonsSetupEvent $event
     * @return void
     *
     * @since   5.0.0
     */
    public function onEditorButtonsSetup(EditorButtonsSetupEvent $event)
    {
        $subject  = $event->getButtonsRegistry();
        $disabled = $event->getDisabledButtons();

        if (\in_array($this->_name, $disabled)) {
            return;
        }

        $this->loadLanguage();

        $button = $this->onDisplay($event->getEditorId());
        $subject->add($button);
    }
    public function onDisplay($name)
    {
        // Register the asset "editor-button.<button name>", will be loaded by the button layout
        $this->getApplication()->getDocument()->getWebAssetManager()
            ->registerScript(
                'editor-button.' . $this->_name,
                'plugins/editors-xtd/insertsitogonvkvideo/assets/button.js',
                [],
                ['type' => 'module'],
                ['editors', 'joomla.dialog']
            );

        Text::script('PLG_INSERTSITOGONVKVIDEO_PLEASE');

        $button = new Button(
            $this->_name,
            [
                'action'  => 'insert-sitogonvkvideo',
                'text'    => Text::_('PLG_INSERTSITOGONVKVIDEO_BUTTON_INSERT'),
                'icon'    => 'fa-solid fa-video',
                // This is whole Plugin name, it is needed for keeping backward compatibility
                'name' => $this->_type . '_' . $this->_name,
            ]
        );
        return $button;
    }
}
