<?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2012 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\CMS\HTML\Helpers;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

abstract class FormBehavior
{

    protected static $loaded = [];

    public static function chosen($selector = '.advancedSelect', $debug = null, $options = [])
    {
        if (isset(static::$loaded[__METHOD__][$selector])) {
            return;
        }

        // If no debugging value is set, use the configuration setting
        if ($debug === null) {
            $debug = JDEBUG;
        }

        // Default settings
        if (!isset($options['disable_search_threshold'])) {
            $options['disable_search_threshold'] = 10;
        }

        // Allow searching contains space in query
        if (!isset($options['search_contains'])) {
            $options['search_contains'] = true;
        }

        if (!isset($options['allow_single_deselect'])) {
            $options['allow_single_deselect'] = true;
        }

        if (!isset($options['placeholder_text_multiple'])) {
            $options['placeholder_text_multiple'] = Text::_('JGLOBAL_TYPE_OR_SELECT_SOME_OPTIONS');
        }

        if (!isset($options['placeholder_text_single'])) {
            $options['placeholder_text_single'] = Text::_('JGLOBAL_SELECT_AN_OPTION');
        }

        if (!isset($options['no_results_text'])) {
            $options['no_results_text'] = Text::_('JGLOBAL_SELECT_NO_RESULTS_MATCH');
        }

        // Options array to json options string
        $options_str = json_encode($options, ($debug && \defined('JSON_PRETTY_PRINT') ? JSON_PRETTY_PRINT : false));

        // Add chosen.js assets

        /** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa            ->registerAndUseScript('joomla-chosen', 'plugins/system/sitogonchosen/src/Extension/libs/assets/chosen.jquery.min.js')
            ->registerAndUseStyle('chosen', 'plugins/system/sitogonchosen/src/Extension/libs/assets/chosen.min.css')
            ->addInlineScript(
                "
		jQuery(document).ready(function (){
			jQuery('" . $selector . "').chosen(" . $options_str . ");
		});
	"
            );

        static::$loaded[__METHOD__][$selector] = true;
    }


}
