<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  editors-xtd.insertsitogonvkvideo
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Plugin\EditorsXtd\Insertsitogonvkvideo\Extension;

use Joomla\CMS\Editor\Button\Button;
use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\Router;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Joomla\Registry\Registry;


\defined('_JEXEC') or die;


/**
 * Кнопка для редактора - вставка VK Video
 *
 * 1.0
 */
final class Insertsitogonvkvideo extends CMSPlugin implements SubscriberInterface
{
    use SiteRouterAwareTrait;
    use DatabaseAwareTrait;


    public static function getSubscribedEvents(): array
    {
        return ['onEditorButtonsSetup' => 'onEditorButtonsSetup'];
    }

    /**
     * @param  EditorButtonsSetupEvent $event
     * @return void
     *
     * @since   5.0.0
     */
    public function onEditorButtonsSetup(EditorButtonsSetupEvent $event)
    {
        $subject  = $event->getButtonsRegistry();
        $disabled = $event->getDisabledButtons();

        if (\in_array($this->_name, $disabled)) {
            return;
        }

        $this->loadLanguage();

        $button = $this->onDisplay($event->getEditorId());
        $subject->add($button);
    }
    public function onDisplay($name)
    {
        $lang = $this->getApplication()->getLanguage();
        $lang->load('plg_editors-xtd_insertsitogonvkvideo');
        Text::script('PLG_INSERTSITOGONVKVIDEO_PLEASE');
        Text::script('PLG_INSERTSITOGONVKVIDEO');
        Text::script('PLG_INSERTSITOGONVKVIDEO_VIDEO_SIZE');
        Text::script('PLG_INSERTSITOGONVKVIDEO_AUTOPLAY');
        Text::script('PLG_INSERTSITOGONVKVIDEO_CANCEL');
        Text::script('PLG_INSERTSITOGONVKVIDEO_INSERT');
        Text::script('PLG_INSERTSITOGONVKVIDEO_INCORRECT_LINK');

        $Systemplugin       = PluginHelper::getPlugin('system', 'sitogonvkvideo');
        $pluginParams = new Registry((array)json_decode($Systemplugin->params));
        $loadIziModalBeforeBody        = $pluginParams->get('loadIziModalBeforeBody', 0);


        HTMLHelper::_('jquery.framework');
        $filemtime_vksitogon = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/editors-xtd/insertsitogonvkvideo/assets/vksitogon.js');
        $filemtime_button = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/editors-xtd/insertsitogonvkvideo/assets/button.js');
        $filemtime_buttonj4 = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/editors-xtd/insertsitogonvkvideo/assets/button_j4.js');

        $assetManager = Factory::getApplication()->getDocument()->getWebAssetManager();

        if ($loadIziModalBeforeBody != 2) {
            $assetManager->registerAndUseStyle('iziModalCss', Uri::root().'plugins/editors-xtd/insertsitogonvkvideo/assets/iziModal.css', []);
        }

        if (!$loadIziModalBeforeBody) {
            $assetManager->registerAndUseScript('iziModalJS', Uri::root().'plugins/editors-xtd/insertsitogonvkvideo/assets/iziModal.js', []);
        }

        $assetManager->registerAndUseScript('vksitogon', Uri::root().'plugins/editors-xtd/insertsitogonvkvideo/assets/vksitogon.js', ['version' => 'ver='.$filemtime_vksitogon]);

        if ((int)JVERSION == 5 || (int)JVERSION == 6) {

            $this->getApplication()->getDocument()->getWebAssetManager()
                ->registerAndUseScript(
                    'editor-button.' . $this->_name,
                    'plugins/editors-xtd/insertsitogonvkvideo/assets/button.js',
                    ['version' => 'v='.$filemtime_button],
                    ['type' => 'module'],
                    ['editors', 'joomla.dialog']
                );


            $button = new Button(
                $this->_name,
                [
                    'action'  => 'insert-sitogonvkvideo',
                    'text'    => Text::_('PLG_INSERTSITOGONVKVIDEO_BUTTON_INSERT'),
                    'icon'    => 'fa-solid fa-file-video',
                    // This is whole Plugin name, it is needed for keeping backward compatibility
                    'name' => $this->_type . '_' . $this->_name,
                    'iconSVG' => '<svg width="24" height="24" viewBox="0 0 32 32"><path d="M25.217 22.402h-2.179c-0.825 0-1.080-0.656-2.562-2.158-1.291-1.25-1.862-1.418-2.179-1.418-0.445 0-0.572 0.127-0.572 0.741v1.968c0 0.53-0.169 0.847-1.566 0.847-2.818-0.189-5.24-1.726-6.646-3.966l-0.021-0.035c-1.632-2.027-2.835-4.47-3.43-7.142l-0.022-0.117c0-0.317 0.127-0.614 0.741-0.614h2.179c0.55 0 0.762 0.254 0.975 0.846 1.078 3.112 2.878 5.842 3.619 5.842 0.275 0 0.402-0.127 0.402-0.825v-3.219c-0.085-1.482-0.868-1.608-0.868-2.137 0.009-0.283 0.241-0.509 0.525-0.509 0.009 0 0.017 0 0.026 0.001l-0.001-0h3.429c0.466 0 0.635 0.254 0.635 0.804v4.34c0 0.465 0.212 0.635 0.339 0.635 0.275 0 0.509-0.17 1.016-0.677 1.054-1.287 1.955-2.759 2.642-4.346l0.046-0.12c0.145-0.363 0.493-0.615 0.9-0.615 0.019 0 0.037 0.001 0.056 0.002l-0.003-0h2.179c0.656 0 0.805 0.337 0.656 0.804-0.874 1.925-1.856 3.579-2.994 5.111l0.052-0.074c-0.232 0.381-0.317 0.55 0 0.975 0.232 0.317 0.995 0.973 1.503 1.566 0.735 0.727 1.351 1.573 1.816 2.507l0.025 0.055c0.212 0.612-0.106 0.93-0.72 0.93zM20.604 1.004h-9.207c-8.403 0-10.392 1.989-10.392 10.392v9.207c0 8.403 1.989 10.392 10.392 10.392h9.207c8.403 0 10.392-1.989 10.392-10.392v-9.207c0-8.403-2.011-10.392-10.392-10.392z"></path></svg>',
                ]
            );
        } else {
            $doc = $this->getApplication()->getDocument();
            $doc->getWebAssetManager()
                ->registerAndUseScript('insertvkcideobutton', 'plugins/editors-xtd/insertsitogonvkvideo/assets/button_j4.js', ['version' => 'ver='.$filemtime_buttonj4], ['defer' => true], ['core']);


            $button          = new CMSObject();
            $button->text    = Text::_('PLG_INSERTSITOGONVKVIDEO_BUTTON_INSERT');
            $button->name    = $this->_type . '_' . $this->_name;
            $button->onclick = 'insertSitogonvkvideoHandler(\'' . $name . '\');return false;';
            $button->icon    = 'fa-solid fa-file-video';
            $button->link    = '#';
            $button->iconSVG = '<svg width="24" height="24" viewBox="0 0 32 32"><path d="M25.217 22.402h-2.179c-0.825 0-1.080-0.656-2.562-2.158-1.291-1.25-1.862-1.418-2.179-1.418-0.445 0-0.572 0.127-0.572 0.741v1.968c0 0.53-0.169 0.847-1.566 0.847-2.818-0.189-5.24-1.726-6.646-3.966l-0.021-0.035c-1.632-2.027-2.835-4.47-3.43-7.142l-0.022-0.117c0-0.317 0.127-0.614 0.741-0.614h2.179c0.55 0 0.762 0.254 0.975 0.846 1.078 3.112 2.878 5.842 3.619 5.842 0.275 0 0.402-0.127 0.402-0.825v-3.219c-0.085-1.482-0.868-1.608-0.868-2.137 0.009-0.283 0.241-0.509 0.525-0.509 0.009 0 0.017 0 0.026 0.001l-0.001-0h3.429c0.466 0 0.635 0.254 0.635 0.804v4.34c0 0.465 0.212 0.635 0.339 0.635 0.275 0 0.509-0.17 1.016-0.677 1.054-1.287 1.955-2.759 2.642-4.346l0.046-0.12c0.145-0.363 0.493-0.615 0.9-0.615 0.019 0 0.037 0.001 0.056 0.002l-0.003-0h2.179c0.656 0 0.805 0.337 0.656 0.804-0.874 1.925-1.856 3.579-2.994 5.111l0.052-0.074c-0.232 0.381-0.317 0.55 0 0.975 0.232 0.317 0.995 0.973 1.503 1.566 0.735 0.727 1.351 1.573 1.816 2.507l0.025 0.055c0.212 0.612-0.106 0.93-0.72 0.93zM20.604 1.004h-9.207c-8.403 0-10.392 1.989-10.392 10.392v9.207c0 8.403 1.989 10.392 10.392 10.392h9.207c8.403 0 10.392-1.989 10.392-10.392v-9.207c0-8.403-2.011-10.392-10.392-10.392z"></path></svg>';

        }


        return $button;
    }
}
